<?php

namespace Webkul\UVDesk\AutomationBundle\Repository;

use Doctrine\Common\Collections\Criteria;
use Webkul\UVDesk\AutomationBundle\Entity\Workflow;

/**
 * WorkflowRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class WorkflowRepository extends \Doctrine\ORM\EntityRepository
{
    const LIMIT = 10;
    
    public function getEventWorkflows($eventName, $isActive = true, $isPredefined = true)
    {
        $queryBuilder = $this->getEntityManager()->createQueryBuilder()
            ->select('workflow')
            ->from(Workflow::class, 'workflow')
            ->leftJoin('workflow.workflowEvents', 'workflowEvents')
            ->where('workflow.status = :status')->setParameter('status', $isActive)
            ->andWhere('workflow.isPredefind = :isPredefined')->setParameter('isPredefined', $isPredefined)
            ->andWhere('workflowEvents.event = :eventType')->setParameter('eventType', $eventName)
            ->orderBy('workflow.sortOrder', Criteria::ASC)
        ;

        return $queryBuilder->getQuery()->getResult();
    }

	public function getWorkflows(\Symfony\Component\HttpFoundation\ParameterBag $obj = null, $container)
    {
        $queryBuilder = $this->getEntityManager()->createQueryBuilder()
            ->select('w.id, w.name, w.status')
            ->from($this->getEntityName(), 'w')
            ->orderBy('w.sortOrder', Criteria::ASC)
        ;

        return ['workflows' => $queryBuilder->getQuery()->getArrayResult()];
    }
}
