<?php

namespace Webkul\UVDesk\CoreFrameworkBundle\Workflow\Actions\Ticket;

use Webkul\UVDesk\AutomationBundle\Workflow\Event;
use Webkul\UVDesk\CoreFrameworkBundle\Entity\TicketStatus;
use Webkul\UVDesk\AutomationBundle\Workflow\FunctionalGroup;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Webkul\UVDesk\AutomationBundle\Workflow\Events\TicketActivity;
use Webkul\UVDesk\AutomationBundle\Workflow\Action as WorkflowAction;

class MarkSpam extends WorkflowAction
{
    public static function getId()
    {
        return 'uvdesk.ticket.mark_spam';
    }

    public static function getDescription()
    {
        return "Mark Spam";
    }

    public static function getFunctionalGroup()
    {
        return FunctionalGroup::TICKET;
    }

    public static function getOptions(ContainerInterface $container)
    {
        return [];
    }

    public static function applyAction(ContainerInterface $container, Event $event, $value = null)
    {
        $entityManager = $container->get('doctrine.orm.entity_manager');

        if (! $event instanceof TicketActivity) {
            return;
        } else {
            $ticket = $event->getTicket();

            if (empty($ticket)) {
                return;
            }
        }

        $status = $entityManager->getRepository(TicketStatus::class)->find(6);

        $ticket
            ->setStatus($status);

        $entityManager->persist($ticket);
        $entityManager->flush();
    }
}
