<?php

namespace Webkul\UVDesk\SupportCenterBundle\UIComponents\Dashboard\Search;

use Webkul\UVDesk\CoreFrameworkBundle\Dashboard\Segments\SearchItemInterface;
use Symfony\Component\Translation\Translator;
use Symfony\Component\Translation\Loader\YamlFileLoader;
use Symfony\Component\HttpFoundation\Request;

class Announcement implements SearchItemInterface
{
    CONST SVG = <<<SVG
<svg fill="#000000" height="30px" width="30px" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <g> 
    <path d="M485.083,36.653H26.917C12.075,36.653,0,48.728,0,63.571V448.43c0,14.842,12.075,26.917,26.917,26.917h458.166 c14.842,0,26.917-12.075,26.917-26.917V63.571C512,48.728,499.925,36.653,485.083,36.653z M127.141,53.834h331.025v19.472H127.141 V53.834z M90.488,53.834h19.472v19.472H90.488V53.834z M53.834,53.834h19.472v19.472H53.834V53.834z M17.181,63.571 c0-5.369,4.367-9.736,9.736-9.736h9.736v19.472H17.181V63.571z M494.819,448.43c0,5.369-4.367,9.736-9.736,9.736H26.917 c-5.369,0-9.736-4.367-9.736-9.736V90.488h477.638V448.43z M494.819,73.306h-19.472V53.834h9.736c5.369,0,9.736,4.367,9.736,9.736 V73.306z"></path> </g> </g> <g> <g> <path d="M466.756,109.96H45.244c-4.744,0-8.591,3.846-8.591,8.591c0,4.744,3.846,8.591,8.591,8.591h421.512 c4.744,0,8.591-3.846,8.591-8.591C475.347,113.806,471.5,109.96,466.756,109.96z"></path> </g> </g> <g> <g> <path d="M329.307,164.94H310.98c-7.907,0-14.617,5.198-16.907,12.353c-73.698,43.017-153.528,50.3-176.506,51.508 c-9.404,0.496-16.77,8.28-16.77,17.724v37.276c0,9.444,7.366,17.228,16.77,17.723c4.579,0.241,11.426,0.725,20.023,1.684 l25.813,94.901c2.097,7.71,9.142,13.094,17.132,13.094h29.617c0.009,0,0.018,0.002,0.028,0.002c0.011,0,0.023-0.002,0.033-0.002 h9.135c4.744,0,8.591-3.846,8.591-8.591s-3.846-8.591-8.591-8.591h-2.601l-21.958-80.51c30.325,7.555,65.45,19.772,99.284,39.52 c2.291,7.156,9.002,12.353,16.907,12.353h18.327c9.79,0,17.754-7.964,17.754-17.754v-164.94 C347.06,172.904,339.096,164.94,329.307,164.94z M137.45,285.916c-8.077-0.864-14.548-1.316-18.981-1.55 c-0.29-0.015-0.491-0.247-0.491-0.565v-37.276c0-0.317,0.202-0.55,0.491-0.566c4.433-0.234,10.904-0.686,18.981-1.55V285.916z M198.935,394.022h-18.402c-0.258,0-0.486-0.174-0.553-0.423l-23.912-87.914c6.135,0.958,12.744,2.124,19.741,3.542 L198.935,394.022z M329.879,347.633c0,0.316-0.257,0.573-0.573,0.573H310.98c-0.316,0-0.573-0.257-0.573-0.573V246.838 c0-4.744-3.846-8.591-8.591-8.591c-4.744,0-8.591,3.846-8.591,8.591v86.016c-50.866-27.553-103.249-39.544-138.595-44.75v-45.881 c35.346-5.206,87.73-17.197,138.595-44.75v12.712c0,4.744,3.846,8.591,8.591,8.591c4.744,0,8.591-3.846,8.591-8.591v-27.491 c0-0.316,0.257-0.573,0.573-0.573h18.327c0.316,0,0.573,0.257,0.573,0.573V347.633z"></path> </g> </g> <g> <g> <path d="M430.103,256.573h-54.98c-4.744,0-8.591,3.846-8.591,8.591c0,4.744,3.846,8.591,8.591,8.591h54.98 c4.744,0,8.591-3.846,8.591-8.591C438.694,260.419,434.847,256.573,430.103,256.573z"></path> </g> </g> <g> <g> <path d="M419.46,206.343c-2.121-4.244-7.281-5.964-11.525-3.842l-36.653,18.327c-4.244,2.122-5.964,7.281-3.842,11.525 c1.505,3.009,4.538,4.75,7.69,4.75c1.291,0,2.601-0.292,3.835-0.908l36.653-18.327 C419.862,215.746,421.582,210.587,419.46,206.343z"></path> </g> </g> <g> <g> <path d="M415.618,312.46l-36.653-18.327c-4.243-2.121-9.403-0.402-11.525,3.842c-2.122,4.244-0.402,9.404,3.842,11.525 l36.653,18.327c1.234,0.616,2.544,0.908,3.835,0.908c3.151,0,6.185-1.741,7.69-4.751 C421.582,319.741,419.862,314.581,415.618,312.46z">
    </path> </g> </g> </g>
</svg>
SVG;

    public static function getIcon() : string
    {
        return self::SVG;
    }

    public static function getTitle() : string
    {
        return "Marketing Announcement";
    }

    public static function getRouteName() : string
    {
        return 'helpdesk_member_knowledgebase_marketing_announcement';
    }

    public static function getRoles() : array
    {
        return ['ROLE_AGENT_MANAGE_MARKETING_ANNOUNCEMENT'];
    }

    public function getChildrenRoutes() : array
    {
        return [];
    }
}
